set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '1221241',
      27,
      2,
      2,
      1,
      '002144',
      NULL,
      NULL,
      39,
      NULL,
      NULL,
      NULL,
      NULL,
      3.968383,
      1.190603,
      0.487710,
      1,
      0,
      1.852465,
      1.628522,
      1,
      1,
      5.582225,
      NULL,
      1,
      1.459473,
      NULL,
      NULL,
      1.152624,
      0.712137,
      0.214305,
      0,
      0,
      1.824262,
      0.675308,
      1,
      3.220428,
      0.601385,
      0,
      1.718931,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.804927,
      1,
      0.713447,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.759812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.746279,
      0.463438,
      0,
      NULL,
      0,
      1,
      NULL,
      0.742540,
      5,
      1,
      NULL,
      0.040928,
      1,
      NULL,
      0.436913,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      8.549688,
      NULL,
      1.400549,
      NULL,
      0.906852,
      1.536000,
      1,
      2,
      0,
      7,
      2,
      6.535674,
      5,
      6,
      3,
      0,
      5,
      NULL,
      7.400968,
      1.400856,
      6.056060,
      0.979307,
      9,
      NULL,
      5.998866,
      NULL,
      2,
      1.172871,
      0.488509,
      1.510110,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.404720,
      0,
      0,
      NULL,
      0.981112,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366682,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.515537,
      1.706509,
      NULL,
      NULL,
      2.716303,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.876821,
      2,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0.137360,
      NULL,
      NULL,
      0.899953,
      2.770196,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.894541,
      0.502307,
      0.387077,
      0.839687,
      NULL,
      3,
      1,
      NULL,
      1.822396,
      NULL,
      1.242239,
      1,
      0.422059,
      0,
      1.727484,
      0.069868,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.013595,
      '02210',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      2,
      '24113',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


