set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      NULL,
      NULL,
      '1022443',
      9,
      1,
      0.364560,
      1,
      '111440',
      2,
      ' 5- 3-1975',
      10.848169,
      NULL,
      1.078137,
      NULL,
      4.983290,
      3,
      NULL,
      0.589791,
      1,
      2,
      0.452503,
      1,
      NULL,
      NULL,
      0,
      1.195355,
      0,
      0.316590,
      3.347451,
      0,
      0,
      1,
      2,
      1.416155,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.671200,
      NULL,
      NULL,
      1.599685,
      2,
      2,
      2.444150,
      0.449735,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      1.838562,
      0.618570,
      0,
      1.309472,
      NULL,
      1,
      NULL,
      0,
      0.998362,
      0,
      2,
      1,
      1,
      1.898142,
      0.166994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.570175,
      0.199049,
      2,
      0.075978,
      NULL,
      2.358002,
      4.957561,
      1,
      0.049793,
      NULL,
      0,
      0,
      0.286184,
      3.438826,
      0,
      0.346796,
      1,
      0.140043,
      1,
      NULL,
      NULL,
      6.025376,
      0,
      7.969568,
      4,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      2,
      3,
      9,
      7.406687,
      NULL,
      5.058609,
      6,
      3,
      5.145967,
      5.621752,
      0,
      2,
      NULL,
      NULL,
      NULL,
      2,
      1.267788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0.227162,
      0.492548,
      0.170830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.979877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.851748,
      2,
      0,
      0,
      2,
      2.058551,
      1.808527,
      NULL,
      NULL,
      1.304447,
      NULL,
      1.194569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3,
      3.535110,
      0.869405,
      1.474247,
      3,
      3.736436,
      1.835565,
      0,
      NULL,
      0,
      0,
      1.953852,
      1.048756,
      NULL,
      0.205170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.316937,
      '34400',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


