set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03',
      9,
      2,
      '2323034',
      NULL,
      3,
      2.527568,
      2,
      '230240',
      0.963413,
      ' 3- 1-1992',
      45.028452,
      5.397114,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.337179,
      0,
      0.045537,
      1,
      0,
      0.695738,
      0,
      2,
      1.430826,
      1.577933,
      0,
      0,
      1.431217,
      0,
      0,
      NULL,
      0.110690,
      NULL,
      0,
      4,
      1,
      0,
      1,
      0.234527,
      1.786952,
      NULL,
      NULL,
      0.337331,
      NULL,
      NULL,
      2.997366,
      1.846712,
      NULL,
      3.801102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.379421,
      0.760356,
      0,
      0.505760,
      1,
      0,
      0.709060,
      0.017477,
      NULL,
      NULL,
      1.823862,
      NULL,
      NULL,
      3,
      NULL,
      0.573553,
      0,
      NULL,
      1,
      1.271380,
      NULL,
      0,
      0.992768,
      0,
      1.670949,
      NULL,
      0.846717,
      NULL,
      0.947653,
      NULL,
      1.061928,
      1.966041,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0.000283,
      6.572773,
      1.301909,
      7,
      NULL,
      2,
      3,
      4.584936,
      3.883514,
      0.812976,
      5,
      0.588173,
      1,
      0,
      6,
      5.773502,
      NULL,
      1,
      2,
      5.282795,
      5,
      5,
      3.903538,
      1.219043,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      1.334853,
      NULL,
      1.862112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364632,
      0.872952,
      NULL,
      NULL,
      NULL,
      4.647603,
      1,
      3,
      NULL,
      NULL,
      2,
      1.883795,
      NULL,
      NULL,
      NULL,
      1.485178,
      0.972435,
      0.038453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641630,
      2,
      NULL,
      1.450518,
      2.378591,
      2,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.714904,
      NULL,
      1.976464,
      NULL,
      0,
      0.554367,
      0.325866,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '',
      '',
      1.487609,
      NULL,
      '',
      '',
      1.175705,
      '',
      NULL,
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


