set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '120',
      '33',
      1.317311,
      11,
      '1412040',
      66.270267,
      0,
      2.760204,
      1,
      '233134',
      NULL,
      ' 9-25-1978',
      40,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.933994,
      0,
      0.931885,
      0.613980,
      0,
      NULL,
      3,
      0.688090,
      0,
      NULL,
      0,
      1.641700,
      3,
      1,
      0.994824,
      1,
      0,
      0.977516,
      NULL,
      1,
      4,
      1,
      1.151418,
      NULL,
      NULL,
      NULL,
      0.794369,
      NULL,
      NULL,
      NULL,
      NULL,
      0.227952,
      3.351972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412389,
      1.246895,
      2.260793,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966693,
      NULL,
      NULL,
      0.594945,
      NULL,
      1.904685,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.977132,
      0,
      1.119353,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.911068,
      4.756801,
      5,
      NULL,
      6,
      1.962757,
      6.819574,
      NULL,
      5.838187,
      7,
      3.646346,
      NULL,
      3,
      NULL,
      5,
      NULL,
      5,
      6.424340,
      NULL,
      NULL,
      6.119694,
      2.372343,
      4.269385,
      NULL,
      NULL,
      1.073148,
      NULL,
      NULL,
      0.862087,
      NULL,
      NULL,
      5.363405,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152284,
      0.462378,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.658872,
      0.307159,
      1.537200,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646280,
      8,
      6.733165,
      NULL,
      0,
      0.713093,
      NULL,
      NULL,
      NULL,
      1.113186,
      1.805003,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.579963,
      NULL,
      NULL,
      2.623340,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2.599716,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '00012',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      1.453954,
      '',
      '',
      '',
      5.444086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


