set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '323',
      '31',
      NULL,
      36.430879,
      NULL,
      110.504585,
      1,
      1.291247,
      NULL,
      '202140',
      1.449083,
      '11-15-2000',
      19,
      30.554400,
      1.188274,
      NULL,
      NULL,
      0,
      0,
      0.151924,
      1,
      NULL,
      0.520784,
      NULL,
      NULL,
      0.902305,
      0.110851,
      0,
      1.134181,
      NULL,
      0.055527,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1.578452,
      5.400963,
      0,
      0.446299,
      1.546365,
      1.455881,
      0.508982,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.931682,
      1,
      0.113098,
      1.954581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333617,
      1.717186,
      0.934764,
      3.150017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618907,
      0.251191,
      NULL,
      1.441689,
      3,
      1,
      3,
      0,
      0.665342,
      0,
      1.893509,
      1,
      0,
      NULL,
      1.417739,
      0.363566,
      NULL,
      1.696658,
      1,
      NULL,
      0.620898,
      NULL,
      NULL,
      1,
      5.229056,
      0,
      7.093781,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5.517736,
      NULL,
      2,
      NULL,
      0.996207,
      5.438832,
      2.287389,
      4,
      7,
      NULL,
      5,
      NULL,
      9,
      7,
      1.028345,
      2,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.896058,
      NULL,
      1,
      1.975116,
      1.107807,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252469,
      NULL,
      1,
      0.885121,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.179355,
      5.256104,
      5.351128,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.663602,
      4.401958,
      0.024673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.984928,
      1,
      0,
      0.039748,
      3,
      2,
      NULL,
      1.533036,
      1.600447,
      NULL,
      NULL,
      0,
      1,
      0,
      1.531571,
      NULL,
      0,
      1.738460,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.606374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '14302',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.887324,
      '',
      '',
      NULL,
      1.170492,
      5,
      3.002930,
      5.687006,
      NULL,
      3.251151,
      0.128298,
      0,
      NULL);
commit;
end;
/


