set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '320',
      '44401401',
      30,
      69.196751,
      '0242324',
      NULL,
      4,
      1,
      NULL,
      '410310',
      NULL,
      NULL,
      42.194471,
      41.529151,
      NULL,
      NULL,
      16.133749,
      1.785576,
      NULL,
      1.747497,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      0.410729,
      NULL,
      NULL,
      NULL,
      0.924751,
      3,
      1.820389,
      NULL,
      0.143068,
      3,
      NULL,
      0,
      1,
      0,
      0.088113,
      1.140771,
      1,
      NULL,
      NULL,
      1.922885,
      NULL,
      NULL,
      NULL,
      1.672170,
      1.464440,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.950906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.584971,
      NULL,
      NULL,
      0.824643,
      0.039882,
      1,
      NULL,
      0.538506,
      0.052905,
      1.286105,
      1.931530,
      0,
      1.501962,
      1.856849,
      0.742487,
      0,
      1,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      0.609499,
      0,
      NULL,
      3,
      5,
      3,
      NULL,
      4,
      NULL,
      0.957344,
      2,
      5.734841,
      6.354682,
      4.527643,
      6,
      4,
      NULL,
      3,
      3,
      0.493859,
      7,
      0.065406,
      NULL,
      NULL,
      0.894350,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.712427,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1.443917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.505073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.362650,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.395032,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.429948,
      1.886681,
      NULL,
      1,
      1.729652,
      0.445657,
      1.310698,
      1.546887,
      NULL,
      0.275832,
      NULL,
      1,
      0.220875,
      1.289057,
      0.486497,
      0,
      1.749173,
      0.227036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.205725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.805620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065928,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      1.397337,
      1.826047,
      0,
      0.040165,
      '21214',
      '03223',
      '',
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      2.267510,
      1.869493,
      2,
      5,
      1,
      0,
      2,
      2,
      1.456335);
commit;
end;
/


