set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32414034',
      NULL,
      29,
      '0341444',
      123,
      4,
      1,
      1,
      '213332',
      2,
      ' 4-21-1988',
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0.407612,
      0,
      0,
      0.661297,
      NULL,
      1.891417,
      1.843933,
      4,
      1.308734,
      NULL,
      1.128290,
      1,
      NULL,
      NULL,
      0.042569,
      0.229179,
      1.295358,
      0.614616,
      1.823210,
      4,
      NULL,
      NULL,
      1,
      NULL,
      0.183021,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.566639,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.164122,
      0,
      0.155371,
      3.185133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.030706,
      1.835776,
      0.960466,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1.995221,
      1,
      1,
      0.559343,
      1,
      1.435081,
      0.813424,
      0,
      1,
      NULL,
      1.702138,
      8,
      1.019411,
      NULL,
      5.654066,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6.276376,
      1,
      6.798601,
      0,
      NULL,
      NULL,
      5.393267,
      1,
      NULL,
      9.499942,
      6,
      4.535051,
      7,
      2.136072,
      NULL,
      0.775179,
      0.228931,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      0.981089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654589,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7.002341,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.854676,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114394,
      NULL,
      NULL,
      1,
      0.307456,
      2.794439,
      3,
      0,
      1.348340,
      1,
      2,
      1.608405,
      1.676701,
      1.520463,
      1.384725,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '01111',
      '00000',
      '',
      NULL,
      NULL,
      '',
      '',
      1.554394,
      '',
      NULL,
      '',
      0.610430,
      5,
      NULL,
      0.623575,
      3.987792,
      3.663621,
      2.237769,
      NULL,
      NULL);
commit;
end;
/


