set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4140',
      '40223130',
      84.154976,
      4.964292,
      '2001202',
      126,
      5,
      2,
      2,
      '103102',
      4,
      ' 9-27-1977',
      21,
      38,
      1,
      NULL,
      0,
      0,
      3.635162,
      0.208612,
      NULL,
      3.381514,
      0,
      NULL,
      0,
      0,
      2,
      0.650008,
      1.242221,
      1,
      NULL,
      0,
      NULL,
      1,
      1.477668,
      NULL,
      1.070015,
      1,
      5.237252,
      0,
      2.103054,
      1,
      0.512961,
      NULL,
      NULL,
      NULL,
      1.610158,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.022252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.446488,
      0,
      3.055129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.287941,
      NULL,
      2,
      NULL,
      1.389028,
      NULL,
      1.805733,
      0,
      0.724941,
      NULL,
      NULL,
      0.403945,
      NULL,
      2,
      0,
      1,
      1,
      0.963474,
      1,
      NULL,
      0.861818,
      1,
      1.442530,
      0.454771,
      2,
      0,
      5,
      0,
      5.099125,
      2,
      NULL,
      NULL,
      3,
      2,
      4,
      1,
      0,
      5.872099,
      NULL,
      2,
      NULL,
      NULL,
      2.527564,
      NULL,
      5,
      7.295243,
      0.382485,
      1.434730,
      0,
      NULL,
      NULL,
      8,
      1.487604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.805139,
      0.238865,
      0,
      1,
      1.049316,
      1,
      1.366806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.554574,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433053,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.202192,
      NULL,
      0,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.623515,
      3.177783,
      0.774636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0,
      2.859343,
      3.345025,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1.543144,
      0.772687,
      NULL,
      1.729742,
      1.023673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '11210',
      '20413',
      NULL,
      1,
      '',
      '',
      '',
      1.722565,
      '',
      '',
      '',
      1,
      2,
      NULL,
      2,
      2.770146,
      2,
      1,
      3.391371,
      NULL);
commit;
end;
/


