set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2403',
      '23000230',
      NULL,
      73.745607,
      NULL,
      186.048024,
      6,
      1,
      1,
      '013410',
      3,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      1,
      0.287954,
      NULL,
      0,
      3,
      1,
      NULL,
      1,
      1.472559,
      4.483552,
      0,
      NULL,
      1,
      0.358873,
      1,
      4.899515,
      0.651681,
      NULL,
      1.984852,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1.692439,
      NULL,
      NULL,
      3.366292,
      1,
      1.865614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.138714,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.049162,
      0.757442,
      0.909232,
      0.653904,
      0,
      NULL,
      1.024766,
      1,
      0.894364,
      1,
      NULL,
      1.550318,
      NULL,
      NULL,
      1.463793,
      NULL,
      NULL,
      1.807443,
      NULL,
      NULL,
      1.955843,
      5,
      1,
      2.206895,
      0,
      6.173211,
      0.868939,
      5,
      NULL,
      3.289832,
      NULL,
      6,
      7.425911,
      0,
      1.255627,
      0.192821,
      NULL,
      7.312532,
      4.724149,
      4,
      1,
      3.180304,
      0,
      5,
      NULL,
      1.276532,
      4.095459,
      1.591254,
      NULL,
      NULL,
      4.848704,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      1,
      0.310266,
      0.693025,
      0.225307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101950,
      NULL,
      NULL,
      NULL,
      NULL,
      0.293309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.518694,
      1.418376,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      4.218767,
      5,
      1,
      1.840363,
      NULL,
      NULL,
      NULL,
      1.737510,
      3.205991,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.182310,
      0.710064,
      0.144871,
      0,
      NULL,
      3.085989,
      NULL,
      0,
      1,
      0.532546,
      0,
      NULL,
      1,
      1,
      1.098105,
      1,
      0,
      0.123942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      '01411',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2.100176,
      2,
      0,
      1,
      1.401036,
      NULL,
      NULL,
      2,
      1.500631);
commit;
end;
/


