set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433079';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      '1223113',
      4,
      4,
      2,
      1,
      '114120',
      1.313503,
      '11-28-1996',
      17.915396,
      NULL,
      1.651387,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.865508,
      0,
      0.824296,
      0.709757,
      1.705777,
      0.651317,
      NULL,
      0,
      1,
      0,
      0.622322,
      3,
      0.588151,
      1,
      1.989852,
      1.953259,
      1.495668,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.129102,
      3.068169,
      3.452829,
      3.425868,
      2.456227,
      NULL,
      1.161626,
      2,
      3.757949,
      1,
      NULL,
      0,
      1.702355,
      2,
      2.592532,
      3.805623,
      NULL,
      2,
      1.790086,
      1.295532,
      0,
      NULL,
      NULL,
      NULL,
      0.283993,
      0,
      NULL,
      NULL,
      0.972064,
      NULL,
      NULL,
      0,
      3.002001,
      3,
      1,
      3,
      NULL,
      1,
      2,
      1.081080,
      0.363511,
      5.877852,
      1.270891,
      0,
      5.385711,
      1,
      0,
      0,
      0,
      1.916302,
      NULL,
      NULL,
      5,
      3,
      NULL,
      2.921061,
      1,
      NULL,
      NULL,
      2.224300,
      NULL,
      0.166372,
      3,
      6.504808,
      2.443463,
      7.234665,
      4,
      3,
      7.069293,
      7,
      NULL,
      4,
      4.181699,
      NULL,
      7.221419,
      9,
      4,
      1.984069,
      NULL,
      3.021507,
      1.754608,
      NULL,
      1.805784,
      0.637504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0.283681,
      NULL,
      1.607216,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.319231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.740979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.898787,
      1,
      0,
      0.315222,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.848256,
      0.579201,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.412769,
      1,
      1,
      2.775628,
      1.902825,
      3.962283,
      0.048884,
      NULL,
      1.401574,
      1.202368,
      1,
      1,
      1,
      NULL,
      0,
      0.139834,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.873510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '31031',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


