set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433079';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      '2223341',
      25,
      5,
      0.700956,
      NULL,
      '343312',
      0.798586,
      ' 0- 7-1986',
      6.315600,
      NULL,
      0.375131,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.254487,
      0,
      0.346891,
      0,
      NULL,
      1.987081,
      1.979935,
      NULL,
      0,
      1.476320,
      1.316520,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      2.933260,
      1.293988,
      1,
      0.161660,
      NULL,
      NULL,
      1.847213,
      NULL,
      NULL,
      6,
      2,
      3.403874,
      1.199324,
      1.026858,
      NULL,
      2.892431,
      NULL,
      0.964454,
      3.621954,
      0.373305,
      1,
      NULL,
      3,
      0,
      0,
      1,
      3,
      3.791064,
      0.289231,
      1.070445,
      5.043530,
      6,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.967188,
      5,
      NULL,
      4.658771,
      3.342814,
      4,
      0.927118,
      1,
      0,
      1.939326,
      NULL,
      NULL,
      3,
      0.182098,
      0.411343,
      NULL,
      NULL,
      0,
      NULL,
      1.563136,
      7.102903,
      1,
      NULL,
      3,
      NULL,
      6.539699,
      NULL,
      NULL,
      3.727134,
      5,
      0.223803,
      0.199563,
      3,
      NULL,
      0.538561,
      9,
      3.948492,
      1,
      5.826393,
      2.586441,
      2,
      7.560037,
      6,
      7,
      NULL,
      1,
      3,
      3,
      1.240657,
      5,
      4.084766,
      1.494818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.859568,
      1,
      1,
      0,
      1.350943,
      2.754345,
      1.091016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638237,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.591338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.172284,
      0.623162,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042436,
      0.807826,
      0.250440,
      2,
      0.483741,
      NULL,
      3,
      1,
      0.509856,
      0.789889,
      0.319549,
      0.052982,
      NULL,
      NULL,
      1.936312,
      1,
      0,
      1.688100,
      1.751037,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '01343',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


