set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433079';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      '13',
      0,
      6.537667,
      NULL,
      10.735766,
      NULL,
      2.427197,
      1,
      '431340',
      1.965041,
      ' 2-15-1998',
      54,
      5,
      0,
      NULL,
      1.839996,
      0.603008,
      2,
      NULL,
      1,
      3,
      0.689986,
      2.684476,
      NULL,
      1.297090,
      NULL,
      NULL,
      1,
      0,
      0.554176,
      0,
      0.994172,
      0,
      NULL,
      0,
      0.681153,
      0,
      4,
      2,
      NULL,
      0.482547,
      0.786373,
      1,
      NULL,
      NULL,
      1.582356,
      NULL,
      NULL,
      4.356364,
      2.912658,
      1.190653,
      0.372520,
      3,
      NULL,
      NULL,
      1,
      0.624802,
      NULL,
      1,
      NULL,
      1.956347,
      NULL,
      2.325672,
      0.719556,
      2.627604,
      2.730523,
      3,
      1,
      1.033259,
      4.771602,
      NULL,
      2,
      1,
      0,
      1.918044,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      3.943002,
      4,
      1,
      0.159787,
      0.011220,
      2.434659,
      0.038440,
      1,
      4.084472,
      1,
      NULL,
      NULL,
      1,
      0.469495,
      NULL,
      0,
      3.019925,
      5,
      NULL,
      2,
      0.080146,
      NULL,
      NULL,
      1.810757,
      3,
      2.267052,
      1.726467,
      NULL,
      3.306351,
      0.969250,
      NULL,
      NULL,
      1,
      7.344520,
      NULL,
      0,
      2.428321,
      NULL,
      7.075643,
      4.841463,
      NULL,
      4.663283,
      NULL,
      2,
      0.461695,
      NULL,
      1.359255,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368309,
      NULL,
      0,
      1,
      0,
      1.611211,
      0.547647,
      1.758857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.342113,
      1,
      NULL,
      0,
      1.406722,
      NULL,
      0.823814,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.880792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.371581,
      0.056534,
      NULL,
      3.275717,
      2.605851,
      1.529780,
      2.647210,
      1,
      1,
      2,
      3.848838,
      0.681212,
      0.848956,
      1,
      1.209709,
      0.283464,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.135228,
      '34033',
      '',
      '',
      1.963173,
      NULL,
      '',
      NULL,
      0.864169,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


