set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433079';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '022',
      '41',
      NULL,
      NULL,
      '3213123',
      98.847289,
      6,
      NULL,
      NULL,
      '203142',
      2.553215,
      '10-29-1977',
      NULL,
      18.849776,
      0.732062,
      NULL,
      1,
      NULL,
      3.829254,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      0,
      0.002323,
      0,
      1,
      1,
      NULL,
      0,
      0.651020,
      NULL,
      0.593702,
      0,
      1.915234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.872188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170266,
      NULL,
      2,
      0,
      3,
      5,
      1.167882,
      0,
      0,
      1,
      0.095209,
      0.072037,
      0,
      1.634818,
      NULL,
      0.387901,
      NULL,
      1.783244,
      0,
      NULL,
      NULL,
      0.729135,
      1,
      NULL,
      1,
      1.176599,
      4,
      2.144938,
      NULL,
      NULL,
      NULL,
      NULL,
      1.209672,
      NULL,
      1.112356,
      3,
      3,
      NULL,
      1.030155,
      0.138922,
      1,
      7,
      6,
      9,
      NULL,
      0.270532,
      1,
      2,
      0.503533,
      NULL,
      NULL,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.320748,
      0.043576,
      NULL,
      0,
      1.684417,
      1,
      NULL,
      1.689904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559915,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.214712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896621,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.326651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016785,
      0,
      NULL,
      0.697010,
      0.436892,
      1,
      NULL,
      3,
      NULL,
      1,
      0.227733,
      1,
      0,
      0,
      0.217267,
      1.089831,
      1.831488,
      0.862288,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.658547,
      '02240',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0.450350,
      '',
      '',
      '',
      4.278683,
      1.202318,
      2,
      1,
      NULL,
      1,
      1.489959,
      3.763423,
      1.683794);
commit;
end;
/


