set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9796819';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '233',
      '41003441',
      18.208453,
      NULL,
      '3300243',
      NULL,
      0,
      1,
      2,
      '331020',
      2,
      ' 8- 6-1974',
      NULL,
      28.253010,
      1.891594,
      NULL,
      4,
      0.256929,
      0.210828,
      NULL,
      1,
      3,
      0,
      2,
      1.475688,
      NULL,
      0.123588,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.163815,
      1,
      0.433272,
      NULL,
      0.300245,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.503523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.007827,
      0,
      1.228590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.317458,
      0,
      0.691401,
      1,
      NULL,
      1,
      1.048670,
      1.375592,
      0,
      0.809436,
      0,
      1.610906,
      NULL,
      1,
      0.763835,
      1,
      0.080216,
      NULL,
      NULL,
      0.478085,
      NULL,
      0.497235,
      1.795277,
      0.449291,
      1.861926,
      NULL,
      0.546345,
      0,
      0.373774,
      0.297722,
      1,
      1.206879,
      NULL,
      1.241382,
      0.018192,
      1,
      1.189332,
      NULL,
      1,
      0,
      4.540902,
      2,
      4.134416,
      1,
      0,
      NULL,
      1.219880,
      NULL,
      NULL,
      2,
      0.877964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0.175684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.724953,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371579,
      1,
      NULL,
      NULL,
      NULL,
      0.023243,
      0.489378,
      2.319088,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.620176,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272437,
      0,
      0.238530,
      0,
      NULL,
      1.481303,
      NULL,
      1,
      NULL,
      0.450719,
      0.342361,
      NULL,
      0.926780,
      0.136727,
      1.160767,
      0,
      0.586989,
      NULL,
      0.237902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '32410',
      '',
      '',
      0.262341,
      '',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      4.822113,
      3.577083,
      NULL,
      0,
      4,
      2,
      NULL,
      NULL,
      NULL);
commit;
end;
/


