set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7214550';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12121333',
      35,
      8.225956,
      '2410342',
      34,
      5,
      NULL,
      NULL,
      '000121',
      1,
      ' 5- 0-1993',
      41.493196,
      5,
      NULL,
      NULL,
      8,
      2,
      1,
      1.474587,
      2.269314,
      0,
      2.783422,
      3,
      1.700503,
      1.175265,
      2.951341,
      4.950614,
      0,
      2.160757,
      6.429074,
      NULL,
      4,
      0,
      NULL,
      1,
      NULL,
      1,
      10,
      0,
      4.125962,
      5,
      3,
      NULL,
      1,
      1.225181,
      0.726072,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.429252,
      1.514507,
      2,
      NULL,
      NULL,
      4,
      2.577829,
      0,
      9,
      6,
      NULL,
      8.830936,
      NULL,
      NULL,
      0,
      0,
      1.710067,
      NULL,
      NULL,
      1.937595,
      4,
      0.153257,
      1.517937,
      3,
      0,
      1,
      0.879642,
      0.797799,
      1.772366,
      0.554950,
      1.001722,
      1,
      0,
      NULL,
      2.659175,
      4.424000,
      0.100054,
      4.074844,
      5,
      1.078041,
      5,
      NULL,
      1,
      0,
      1.420899,
      3,
      3,
      0.796197,
      1,
      2.637992,
      10,
      NULL,
      2,
      NULL,
      NULL,
      1.559081,
      9,
      11.922972,
      1,
      1,
      2,
      8,
      8,
      4,
      1.607184,
      2,
      0.337130,
      NULL,
      0.927818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.843196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.628026,
      NULL,
      3.506421,
      2,
      1.914200,
      3.025757,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.068012,
      0,
      0.123773,
      3.849574,
      1,
      3.581581,
      1.039192,
      2.473993,
      0.784087,
      1.607003,
      1.454716,
      NULL,
      NULL,
      1,
      0.220939,
      1,
      NULL,
      0.232340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.657926,
      '31032',
      '30101',
      '',
      0,
      '',
      '',
      '',
      0.543931,
      NULL,
      NULL,
      '',
      2,
      3.375913,
      2,
      3.409576,
      NULL,
      NULL,
      1,
      1,
      1);
commit;
end;
/


