set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9766685';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04002111',
      20.431147,
      NULL,
      '1201124',
      6,
      2,
      1,
      NULL,
      '232032',
      3.810462,
      ' 6-17-1992',
      154.437958,
      14.339059,
      1.585173,
      NULL,
      1.664991,
      0.150317,
      0,
      1.266571,
      1.346663,
      0,
      1.764306,
      NULL,
      1,
      1,
      7,
      1,
      0.636730,
      0,
      0,
      NULL,
      5.396858,
      NULL,
      1.503874,
      0.969389,
      0.125861,
      1,
      NULL,
      1,
      0,
      1.787541,
      1.493504,
      0.691216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.551175,
      1.759903,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.498022,
      0.263473,
      1,
      1,
      2,
      0,
      0.021357,
      0,
      0.882003,
      2.870221,
      1,
      0,
      2.685924,
      1.247430,
      0.763003,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1.016517,
      NULL,
      1,
      2.738818,
      1.837496,
      NULL,
      1,
      0.747607,
      0.150407,
      3.443777,
      0,
      0.859545,
      0.609830,
      0,
      5,
      NULL,
      1,
      6,
      NULL,
      7.507078,
      NULL,
      0,
      NULL,
      2,
      0,
      0.029395,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.078836,
      1,
      1,
      1.596892,
      3.318105,
      0.986166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.686026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.350214,
      0.539559,
      1.067938,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.807434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.743490,
      1.969727,
      3,
      NULL,
      1,
      1.695230,
      NULL,
      0.144465,
      1.561122,
      0,
      1,
      0,
      1,
      1,
      1.318870,
      0,
      1.361154,
      1.929569,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '10031',
      '',
      '',
      0.546229,
      NULL,
      '',
      '',
      1.294510,
      '',
      NULL,
      '',
      4.659118,
      0.725333,
      1,
      NULL,
      3,
      2,
      NULL,
      3.405512,
      0);
commit;
end;
/


