set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9766685';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '213',
      NULL,
      45.789760,
      55.333268,
      '0214043',
      22.084546,
      NULL,
      1,
      3,
      '142411',
      NULL,
      NULL,
      28.946436,
      NULL,
      1,
      NULL,
      1.815368,
      1.848147,
      1.575261,
      0.971078,
      0.258026,
      0,
      0,
      0.891605,
      NULL,
      0.123917,
      6.427216,
      1.656266,
      0.690962,
      1.645707,
      NULL,
      1,
      3.359790,
      0.558466,
      1.682118,
      NULL,
      0.660120,
      1,
      2.110272,
      0,
      0.728903,
      1.103157,
      1,
      0.177530,
      NULL,
      NULL,
      0.520269,
      NULL,
      NULL,
      1.703647,
      1,
      1.975362,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.106844,
      1.519043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.706707,
      3.836413,
      1,
      NULL,
      1,
      1,
      0.496876,
      1,
      0.486452,
      NULL,
      1.381852,
      0,
      1.017453,
      0,
      0.214054,
      1.906843,
      1.050421,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.701211,
      4,
      1.233778,
      1,
      0.386710,
      1,
      3,
      0.314448,
      2,
      5.812684,
      7.762762,
      5.299591,
      0.623709,
      1.299749,
      0.570941,
      0,
      1,
      1.831387,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.062421,
      0,
      1,
      1.295689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.926067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.254395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776305,
      0,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.899185,
      1.498575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099873,
      NULL,
      3.903788,
      1.748672,
      0.736040,
      1.140396,
      1,
      1.326077,
      0,
      1.851543,
      0.125647,
      1.383460,
      0.694733,
      NULL,
      1.397150,
      0.531161,
      1.448351,
      0.104065,
      0.639742,
      0.290285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.076474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.967179,
      '13010',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.929546,
      '',
      NULL,
      '',
      NULL,
      4.493563,
      2,
      0.946476,
      NULL,
      1.565732,
      1.821298,
      1.633198,
      3);
commit;
end;
/


