set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9766685';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1412',
      NULL,
      24.393502,
      NULL,
      NULL,
      NULL,
      4,
      1,
      2,
      '103342',
      NULL,
      ' 2-16-1990',
      NULL,
      32,
      1,
      NULL,
      NULL,
      1,
      3,
      0.052497,
      0.099049,
      1,
      0.996922,
      0,
      1,
      0.324305,
      NULL,
      1.782057,
      1,
      0,
      0,
      0.421647,
      0,
      0,
      NULL,
      0.806763,
      1,
      1.172881,
      5,
      0,
      3.832976,
      0.572095,
      1.899642,
      1,
      NULL,
      NULL,
      1.300162,
      NULL,
      NULL,
      0.223680,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.438349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108417,
      0,
      0,
      1.669361,
      0.690031,
      NULL,
      NULL,
      NULL,
      1.712884,
      0.992547,
      0.201865,
      0.640827,
      0,
      1.240566,
      1,
      1,
      1.123993,
      1,
      0,
      NULL,
      1.293273,
      0,
      0,
      NULL,
      0.071071,
      0,
      1,
      2.588487,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      0.218171,
      NULL,
      3.167773,
      1,
      NULL,
      0,
      NULL,
      0,
      6,
      NULL,
      NULL,
      0,
      1.940939,
      2,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.780341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063344,
      3.909608,
      0.054321,
      1.303192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.847656,
      3.478341,
      1.348340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210694,
      NULL,
      0.618255,
      0.026250,
      NULL,
      NULL,
      0,
      2.930300,
      0.747629,
      0,
      1.960654,
      1,
      0.463701,
      0,
      1,
      NULL,
      1.243737,
      1.986327,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.602985,
      '31114',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.654166,
      '',
      NULL,
      '',
      4,
      0,
      NULL,
      NULL,
      0.614402,
      2.291973,
      2,
      NULL,
      NULL);
commit;
end;
/


