set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03',
      11.201137,
      34,
      '2031310',
      180.479122,
      3,
      NULL,
      0,
      '112004',
      2.226332,
      ' 5-17-2000',
      64,
      54.518074,
      NULL,
      NULL,
      0.825837,
      0.808031,
      0.987248,
      0.219406,
      NULL,
      0,
      1.681855,
      NULL,
      NULL,
      NULL,
      1.278354,
      NULL,
      1,
      NULL,
      1.170798,
      0,
      1.448789,
      1.695728,
      0.772609,
      NULL,
      0,
      NULL,
      0.065227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.876652,
      1.118644,
      1.604878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133561,
      0,
      1,
      0.428096,
      1,
      0,
      0.402379,
      1,
      NULL,
      0,
      NULL,
      1.627535,
      1.163015,
      1.434899,
      0,
      NULL,
      0,
      0.044752,
      1.452023,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      0.851958,
      NULL,
      NULL,
      1,
      1.254978,
      NULL,
      0.910768,
      NULL,
      0.116947,
      0,
      0.554120,
      0,
      1,
      NULL,
      0.569055,
      1,
      1.685681,
      1,
      0.764536,
      0,
      0,
      NULL,
      0.828614,
      1,
      NULL,
      NULL,
      3.020116,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.396974,
      0.424935,
      0,
      0,
      0.989535,
      0,
      0.719318,
      0.508753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.335990,
      1.825499,
      1.184428,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.446122,
      0.382037,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780186,
      1,
      NULL,
      1,
      0,
      1,
      1.383453,
      1.628277,
      NULL,
      0,
      1.402592,
      1.831572,
      0.754770,
      1.015877,
      NULL,
      NULL,
      1,
      0.424127,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '12402',
      NULL,
      NULL,
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      4.502946,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      2,
      2.943573);
commit;
end;
/


