set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '340',
      '10020222',
      5,
      28,
      '4032022',
      NULL,
      2,
      0.024889,
      3,
      '140313',
      3.662242,
      ' 1- 5-1989',
      23,
      19.577444,
      0,
      NULL,
      0.713138,
      0,
      1.287853,
      0.216619,
      0.638405,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1.840474,
      1,
      NULL,
      1,
      1,
      0.023831,
      1.409746,
      0.962809,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.864368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.231502,
      1.342917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.383054,
      NULL,
      0,
      NULL,
      0,
      1.764656,
      1.367860,
      1.135401,
      0.133121,
      0,
      0,
      1.840871,
      1,
      0,
      0,
      1,
      0,
      0,
      0.707899,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.986098,
      NULL,
      1.553518,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0.579042,
      1.185778,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      1.538576,
      NULL,
      0.853108,
      0.575855,
      NULL,
      1.844594,
      0,
      NULL,
      NULL,
      8.543778,
      0.810232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491371,
      0.255495,
      NULL,
      1,
      0,
      0.095768,
      1.911577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.734425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.134832,
      1,
      1.949208,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.453523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.537465,
      NULL,
      1.437742,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1.488468,
      1,
      0.226759,
      1.442975,
      0.719474,
      NULL,
      1.487516,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.269419,
      '01202',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      1,
      NULL,
      1.157560,
      3.690663,
      2,
      NULL,
      1,
      1);
commit;
end;
/


