set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '131',
      '32130431',
      65,
      8,
      '2013404',
      65,
      3,
      0,
      2,
      '044333',
      4,
      '10-23-1974',
      NULL,
      NULL,
      1,
      NULL,
      1.941601,
      0.217476,
      3,
      0.714084,
      1.539539,
      0,
      1,
      1.621605,
      0,
      0.476111,
      0.744281,
      NULL,
      1.003788,
      0,
      NULL,
      1,
      0.778427,
      NULL,
      0,
      0,
      0.422974,
      0,
      0.802128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.995636,
      1.054684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297546,
      0,
      1,
      0.707303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.857424,
      1,
      NULL,
      1,
      1.661389,
      1.365913,
      NULL,
      0.084401,
      1.496191,
      0.760027,
      1,
      1,
      NULL,
      0.177452,
      1.843602,
      NULL,
      0,
      1,
      0.244922,
      NULL,
      NULL,
      1.550996,
      NULL,
      0.054726,
      1.174627,
      1,
      0,
      1.247491,
      NULL,
      NULL,
      NULL,
      NULL,
      1.250015,
      0.564102,
      1.466997,
      0.881768,
      NULL,
      0.292196,
      NULL,
      NULL,
      1.919142,
      NULL,
      1.305746,
      1,
      1.330563,
      1.439287,
      0,
      0.683171,
      0.939378,
      NULL,
      NULL,
      6.027559,
      0.570885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.957655,
      1,
      0,
      0.235475,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.264241,
      1.665353,
      0.360544,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.037623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081965,
      0,
      1,
      NULL,
      NULL,
      0.980930,
      1.628398,
      0,
      1,
      NULL,
      1,
      0.274055,
      1,
      NULL,
      1.953468,
      NULL,
      1.917586,
      1,
      1.140844,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '11032',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.254233,
      NULL,
      '',
      '',
      2.232742,
      1,
      0.409585,
      0.780355,
      2.806952,
      1,
      3,
      NULL,
      3.752241);
commit;
end;
/


