set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      71,
      '4331133',
      NULL,
      3,
      2,
      1,
      '023124',
      0,
      NULL,
      35,
      33,
      0.187914,
      NULL,
      NULL,
      0.989296,
      1.396008,
      NULL,
      0.679338,
      2.446633,
      NULL,
      0.919917,
      0.316279,
      0,
      0.337713,
      NULL,
      NULL,
      1,
      1,
      1.046854,
      1.595698,
      1,
      1.521734,
      1.568157,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.272926,
      0.186160,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.731259,
      1.734935,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686445,
      1,
      1,
      1.379326,
      0.021707,
      1.453612,
      NULL,
      0,
      1.665100,
      0.197755,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0.327620,
      NULL,
      1,
      1.662921,
      0.435245,
      1.188314,
      0.905874,
      0.607795,
      0,
      1.780598,
      1.871263,
      0,
      0,
      NULL,
      0.313867,
      0.581965,
      1,
      1,
      1.980175,
      1,
      0.581456,
      NULL,
      1,
      0,
      NULL,
      0.506203,
      1,
      0.041974,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6.471185,
      1.018489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806914,
      0.838568,
      0,
      NULL,
      0.963888,
      0,
      1,
      0.822821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.609465,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.743350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.343803,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.210442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.933447,
      1.912114,
      0,
      0.776338,
      1.657911,
      0.461941,
      0,
      NULL,
      0,
      1.883291,
      NULL,
      0,
      1,
      0,
      0.017240,
      0,
      1,
      0.587114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.039063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.114082,
      '22043',
      NULL,
      '',
      1.803665,
      NULL,
      '',
      '',
      1.555323,
      '',
      '',
      '',
      0.962861,
      NULL,
      NULL,
      5.789602,
      0.443983,
      2,
      3,
      2,
      NULL);
commit;
end;
/


