set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9305787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-4-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '142',
      NULL,
      33.903955,
      NULL,
      '1224203',
      11,
      2,
      0,
      NULL,
      '301033',
      2,
      ' 6-17-1980',
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      3.193363,
      1,
      1,
      1.371886,
      1,
      0,
      5,
      0.385493,
      1,
      7.861580,
      1.754953,
      NULL,
      7,
      NULL,
      7.687975,
      6,
      0,
      1,
      10,
      1,
      NULL,
      0,
      2.900432,
      0.515881,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0.248242,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.756981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618758,
      1.480082,
      2,
      1.386317,
      5.497656,
      0.651743,
      0.593895,
      0.630442,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.894961,
      0,
      0,
      0.334046,
      1.494264,
      0.056273,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      1.717781,
      4,
      0.897094,
      3,
      1,
      1,
      3.998177,
      1,
      1.540102,
      4.298439,
      5,
      0.190758,
      2,
      0,
      5.962721,
      0,
      6,
      1,
      5.555389,
      7,
      NULL,
      0.401926,
      0,
      1.363726,
      0.430404,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.831109,
      NULL,
      0,
      NULL,
      1,
      0.597346,
      0.955742,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.548751,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.133767,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.127226,
      0,
      NULL,
      1,
      0,
      0.049057,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672816,
      NULL,
      1.289731,
      1,
      3.335194,
      2.819532,
      1.277253,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1.222533,
      1.294914,
      1.235500,
      1.306181,
      0,
      1.513640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '04130',
      '',
      NULL,
      0.716630,
      NULL,
      '',
      NULL,
      1.040653,
      NULL,
      '',
      '',
      2.308741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


