set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9305787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32',
      53.472586,
      15,
      '1332143',
      72,
      NULL,
      1.389619,
      1,
      '002341',
      4.991625,
      NULL,
      40,
      35.768474,
      1.969234,
      NULL,
      NULL,
      3,
      1.891921,
      NULL,
      3.964880,
      1.230886,
      0,
      1,
      0,
      NULL,
      1.566434,
      0,
      NULL,
      7,
      1,
      0.314573,
      6.370918,
      1,
      1.860185,
      1,
      0.830372,
      1.761544,
      6,
      1,
      1,
      1.840267,
      NULL,
      1.816935,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.883924,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841434,
      NULL,
      0,
      NULL,
      1.527765,
      0,
      0,
      NULL,
      NULL,
      0.711548,
      0,
      0,
      1,
      1,
      0.357932,
      NULL,
      1,
      1.659234,
      1,
      NULL,
      NULL,
      4,
      1.118621,
      0,
      NULL,
      1.252137,
      5,
      1.642903,
      3.040370,
      1,
      0.499592,
      1,
      0.807109,
      1,
      NULL,
      5.120424,
      0,
      1,
      1,
      NULL,
      0,
      5,
      NULL,
      5.034958,
      2.575003,
      0.502940,
      1,
      0,
      NULL,
      0,
      NULL,
      6.365237,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.598200,
      1.122377,
      1,
      2,
      NULL,
      NULL,
      1.744295,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405188,
      0.346814,
      0.768387,
      0,
      0.693178,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.666149,
      1.497908,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.089457,
      0.885104,
      0.099007,
      1.831568,
      2,
      3,
      3,
      0.901003,
      2.825571,
      0.041275,
      1,
      1,
      1.841111,
      0,
      NULL,
      1,
      0,
      NULL,
      1.072088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '43423',
      '',
      NULL,
      0.130901,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      2.217443,
      3.571525,
      0,
      3,
      NULL,
      NULL,
      3.497273,
      1);
commit;
end;
/


