set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9305787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '143',
      '22040012',
      NULL,
      33,
      NULL,
      106,
      5,
      2.219715,
      NULL,
      NULL,
      2.792222,
      '10-27-1987',
      29.989384,
      48,
      1,
      NULL,
      0.055415,
      NULL,
      NULL,
      0.205127,
      1.313984,
      3,
      0.876577,
      0,
      NULL,
      0.265790,
      2.801921,
      0.871450,
      1,
      1.707477,
      1.264589,
      1,
      6,
      1,
      4.255878,
      1.918619,
      0,
      0,
      6,
      1,
      5,
      1.945073,
      1.675002,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.506867,
      0,
      1.070297,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.505363,
      NULL,
      1.824538,
      0.499537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.244004,
      1,
      0.287695,
      1,
      0.096325,
      0,
      0,
      1.269173,
      0.413007,
      1,
      0.126174,
      1.651828,
      1.348764,
      1.450652,
      1,
      1.753774,
      0.718797,
      0.550717,
      NULL,
      NULL,
      1.042339,
      NULL,
      1.928559,
      1.367007,
      1,
      NULL,
      0.673766,
      1.279389,
      1.596433,
      1,
      0.124201,
      0.053607,
      1,
      1,
      2,
      NULL,
      0,
      2.509706,
      NULL,
      2.065459,
      0.237897,
      NULL,
      7,
      1,
      7.589991,
      0,
      1.158355,
      NULL,
      3.998977,
      0.405488,
      0.069458,
      8.221701,
      0.453452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.571563,
      0,
      1,
      0.247616,
      1,
      0,
      1.144467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811156,
      7,
      1.024167,
      0.382125,
      1,
      1.921705,
      NULL,
      NULL,
      NULL,
      1,
      3.023969,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.974796,
      0,
      0.054588,
      1.218099,
      NULL,
      1.995489,
      1.388231,
      NULL,
      0,
      NULL,
      0,
      0,
      0.938183,
      0,
      NULL,
      0.277124,
      0.515547,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '00210',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      0.603151,
      '',
      '',
      '',
      5.372156,
      4.719424,
      2.461054,
      3,
      0.013556,
      3,
      2.533223,
      1,
      3.349988);
commit;
end;
/


