set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9305787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '233',
      '01003122',
      47.451411,
      48,
      '3111012',
      138,
      6,
      3,
      2,
      '234332',
      1.847951,
      ' 5-11-2003',
      29,
      17.245704,
      0.247777,
      NULL,
      NULL,
      1.090486,
      3.046628,
      1.991186,
      1.454594,
      0,
      1.659300,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.162135,
      NULL,
      0.002114,
      9.776627,
      1.924647,
      0,
      0,
      3.072799,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.261021,
      NULL,
      NULL,
      0.371977,
      0.041745,
      0,
      1.374059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.090786,
      1.444237,
      1,
      1.497832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.904380,
      0.558695,
      1.393309,
      0.631741,
      0,
      NULL,
      0.996013,
      1.837114,
      1.528712,
      1.431138,
      0.341178,
      0,
      0.407597,
      1,
      1.467337,
      1,
      1.678465,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.430955,
      1.962156,
      0.381240,
      NULL,
      5.441776,
      0.666525,
      2.939087,
      0.333559,
      1,
      5.132066,
      0.910981,
      NULL,
      5.540997,
      0.089507,
      NULL,
      1.393430,
      NULL,
      1,
      2,
      9.152462,
      1.139387,
      NULL,
      9,
      0,
      0,
      0.187996,
      3,
      NULL,
      1.321447,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.215126,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.669278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4.413713,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.481194,
      0.172614,
      1.634616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.123260,
      NULL,
      1.716495,
      1,
      3,
      NULL,
      3.679240,
      NULL,
      NULL,
      0.704209,
      1.726745,
      NULL,
      1.838201,
      NULL,
      1.223452,
      0,
      0,
      0,
      0.338247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '42342',
      '',
      '',
      1.907912,
      '',
      '',
      '',
      0.810330,
      '',
      NULL,
      '',
      1.129077,
      NULL,
      NULL,
      0,
      2,
      2,
      0.425487,
      3.423592,
      3.756215);
commit;
end;
/


