set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9305787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '221',
      '32124401',
      46,
      NULL,
      '1233420',
      43,
      2,
      NULL,
      3,
      '103224',
      NULL,
      NULL,
      7.551248,
      50.242292,
      1.846731,
      NULL,
      1.429404,
      NULL,
      1.990727,
      0.838386,
      0,
      0.772792,
      0.512160,
      1.570304,
      3.829832,
      NULL,
      2,
      NULL,
      0.237401,
      2.560596,
      0.435535,
      NULL,
      NULL,
      1,
      1,
      0.974131,
      0,
      NULL,
      3.199835,
      1,
      0,
      5.511612,
      1,
      0,
      NULL,
      NULL,
      1.603032,
      NULL,
      NULL,
      0.481081,
      NULL,
      NULL,
      1.562541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.456757,
      1.289357,
      0.636364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.329706,
      1,
      0.100159,
      1,
      1,
      1.508390,
      0.845452,
      NULL,
      0,
      NULL,
      1,
      1.072758,
      NULL,
      0,
      1.295061,
      1,
      NULL,
      1,
      0.389203,
      NULL,
      1.870687,
      NULL,
      1.128344,
      0.842566,
      0.281097,
      0,
      2,
      NULL,
      NULL,
      1,
      1.197671,
      5,
      0,
      0,
      3,
      4,
      0,
      0,
      5,
      NULL,
      4,
      4,
      6.058740,
      6.403714,
      NULL,
      0,
      1.761170,
      NULL,
      0,
      0,
      0,
      NULL,
      0.494084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988022,
      0,
      1,
      0,
      0,
      NULL,
      1.398590,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.211050,
      1,
      0,
      0,
      1.892801,
      NULL,
      NULL,
      NULL,
      1.229939,
      1.453608,
      1.687505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.314831,
      0.166281,
      3.785399,
      2,
      0,
      1,
      NULL,
      0,
      0,
      0.484139,
      1.302996,
      0.936098,
      NULL,
      1,
      0,
      1.351249,
      1.667646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.866416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.894607,
      NULL,
      '',
      '',
      0.629203,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      4,
      1.944104,
      2.041554,
      NULL,
      1,
      1,
      3,
      3);
commit;
end;
/


