set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9305787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3034',
      NULL,
      50,
      17,
      NULL,
      206.998256,
      2,
      0,
      2,
      '113340',
      3.678847,
      ' 1- 6-1982',
      46,
      34.245810,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.442861,
      0,
      NULL,
      0,
      1,
      1,
      0,
      3,
      1.144891,
      1,
      3,
      0.188635,
      1,
      9,
      1.896258,
      NULL,
      1.682128,
      1.823593,
      1,
      4.115107,
      1,
      1,
      1.842482,
      2.567542,
      0.830168,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.282366,
      0,
      NULL,
      1.660110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.963292,
      0,
      1.915313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.399890,
      1.477605,
      1,
      0.734687,
      1,
      0.434200,
      1,
      0.032827,
      1,
      0,
      NULL,
      1.529640,
      0,
      0.196921,
      NULL,
      1.191276,
      1.402960,
      1.863013,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      5.704596,
      1.081839,
      NULL,
      0,
      1,
      2,
      1.229475,
      1.451424,
      4,
      2.583130,
      0.276565,
      NULL,
      NULL,
      0,
      0.622757,
      6.573122,
      4,
      10.335569,
      1,
      0.568600,
      0,
      0,
      NULL,
      0,
      1.171047,
      0.763049,
      1.697812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.832519,
      0,
      NULL,
      0.954790,
      NULL,
      1,
      1.678620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.120788,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877624,
      1,
      0.030493,
      1.977647,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.825070,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.654033,
      1.292093,
      0.721285,
      NULL,
      2,
      2,
      NULL,
      0.492205,
      2,
      1,
      0,
      0.066014,
      0.675043,
      1,
      1.852414,
      NULL,
      NULL,
      1.489141,
      1.605276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '31043',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.496526,
      '',
      '',
      '',
      2,
      NULL,
      1.878727,
      NULL,
      1.955524,
      1,
      2.338652,
      3,
      3.280111);
commit;
end;
/


