set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9305787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2121',
      '01434002',
      95,
      30,
      '1333034',
      93.871073,
      2,
      0.373104,
      NULL,
      '244224',
      6,
      '11-14-1981',
      36.617261,
      14.502683,
      1.104879,
      NULL,
      NULL,
      1.247912,
      NULL,
      1.260931,
      1.762751,
      1.813583,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.601464,
      4,
      0,
      1.933932,
      4,
      NULL,
      7.518245,
      1,
      NULL,
      0.510612,
      3,
      0,
      NULL,
      3.210422,
      1,
      0.247290,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.897689,
      0,
      1.672525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.109798,
      NULL,
      NULL,
      1.044115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.981702,
      1.327408,
      0,
      1,
      NULL,
      NULL,
      0.725392,
      1,
      0,
      0.533975,
      0.597277,
      NULL,
      1.572772,
      1.906036,
      0,
      1,
      0.514457,
      NULL,
      0,
      NULL,
      1.067060,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0.037065,
      1.700822,
      0,
      1,
      2.970047,
      2,
      6,
      8.615319,
      6,
      5.941325,
      4.245894,
      3.572113,
      NULL,
      2,
      1.038328,
      NULL,
      0.067906,
      9.105206,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.795845,
      0,
      1,
      0,
      1.076511,
      1.639039,
      0,
      0.716243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      NULL,
      0.670210,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.079344,
      NULL,
      1.894721,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.726158,
      0.264882,
      1.884001,
      2,
      1.982206,
      NULL,
      NULL,
      NULL,
      1.389377,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.778742,
      3.344421,
      NULL,
      1.531268,
      1,
      0.708513,
      NULL,
      3.849842,
      NULL,
      3.877902,
      1.848212,
      0.694004,
      1.543065,
      0.649901,
      1,
      1,
      NULL,
      1,
      1.378035,
      1.407430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      5.865642,
      0.683154,
      NULL,
      1.205743,
      1.620754,
      0.064036,
      1,
      1);
commit;
end;
/


