set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9305787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-8-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3202',
      '03001101',
      2,
      69,
      '2043213',
      161,
      NULL,
      0,
      2,
      '421031',
      1.778469,
      NULL,
      57.783213,
      45.502696,
      0,
      NULL,
      1.833986,
      0.922823,
      3.844265,
      NULL,
      NULL,
      3.158059,
      1,
      0.953707,
      0.228836,
      NULL,
      2,
      NULL,
      1.355087,
      NULL,
      0.544822,
      0.451428,
      8.174194,
      1.221764,
      3,
      0,
      0,
      NULL,
      1.932852,
      0,
      2.680999,
      1.867245,
      NULL,
      1.483298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.167103,
      NULL,
      1.625947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232878,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.678592,
      0,
      0,
      0.449875,
      1.392530,
      0,
      1,
      1,
      1.949416,
      1.930318,
      1,
      0.330620,
      1.068903,
      0.580904,
      1.322170,
      0,
      NULL,
      NULL,
      1.156457,
      4,
      NULL,
      1,
      0.130286,
      0.475032,
      NULL,
      1,
      1,
      1.943639,
      0,
      3.394641,
      1,
      0.168912,
      NULL,
      0,
      0.146569,
      NULL,
      0.163664,
      2.938239,
      4.806624,
      11.820812,
      3.694551,
      8,
      0,
      5.703604,
      NULL,
      1,
      0.059023,
      1,
      1,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158046,
      NULL,
      NULL,
      NULL,
      1,
      1.291479,
      0.790258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.562780,
      0.194593,
      NULL,
      NULL,
      NULL,
      0.381298,
      NULL,
      2.158440,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733164,
      2.651834,
      1,
      0,
      1,
      NULL,
      3.065334,
      2.291899,
      0,
      2.539944,
      0.686418,
      NULL,
      NULL,
      1,
      1.237878,
      0,
      0.564075,
      0.407215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '34022',
      '',
      '',
      1.480960,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      6.038874,
      1.574284,
      3,
      2.111267,
      0,
      1.798710,
      2,
      0.709417);
commit;
end;
/


