set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '1130203',
      31.701803,
      3,
      0,
      3,
      '321234',
      1,
      ' 1- 3-1974',
      42.788400,
      NULL,
      0.213549,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1,
      1.803646,
      0.061921,
      0,
      1,
      0.566834,
      1.121216,
      0.933862,
      1.338954,
      2.582361,
      0.990516,
      5,
      0,
      1,
      0.995040,
      NULL,
      0,
      NULL,
      NULL,
      1.150832,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816002,
      NULL,
      1.044421,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.060279,
      1,
      NULL,
      0.614080,
      0,
      0,
      0.195545,
      0.904323,
      NULL,
      NULL,
      1.093152,
      1.701688,
      0,
      0.819401,
      0.590471,
      1.180977,
      NULL,
      NULL,
      0,
      6,
      1,
      0,
      2,
      0,
      6.589757,
      1.760297,
      6,
      1,
      0,
      0.598171,
      3.894853,
      1.174161,
      3.268006,
      1,
      5.319071,
      1,
      0,
      10,
      NULL,
      NULL,
      0.868682,
      11,
      4,
      1.790151,
      2.145203,
      NULL,
      0.022805,
      NULL,
      NULL,
      NULL,
      1.578949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347978,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0.640653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.017083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.762640,
      1,
      0,
      NULL,
      2.433750,
      7,
      1.754552,
      1.162481,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.038875,
      1.847881,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.996202,
      0.193032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.857136,
      2.755181,
      1,
      1.856078,
      2.119375,
      NULL,
      1.527943,
      3,
      0,
      0,
      1.180109,
      0.138913,
      0.288667,
      0,
      1,
      0.940628,
      0.609199,
      0.992898,
      NULL,
      1.610060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.961598,
      '42402',
      '',
      '',
      1.807687,
      '',
      '',
      NULL,
      1.509281,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


