set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-7-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      118.048468,
      4,
      0,
      NULL,
      '101043',
      0.316935,
      ' 9-14-1986',
      34,
      NULL,
      0.550953,
      NULL,
      NULL,
      1.795140,
      1.326652,
      1.137697,
      NULL,
      1,
      2.817148,
      1,
      1,
      0.205176,
      4,
      0.504592,
      0.337552,
      0,
      1,
      0.107922,
      4,
      0,
      0.343182,
      1,
      0.155102,
      NULL,
      4,
      1,
      1.747220,
      NULL,
      0,
      0.884796,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.480205,
      1,
      1.330822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666027,
      NULL,
      0.016200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.728400,
      0,
      0,
      0.420251,
      0,
      1,
      NULL,
      1.918818,
      0.900320,
      1.413176,
      NULL,
      NULL,
      0.969777,
      0,
      1.854442,
      1,
      NULL,
      NULL,
      1.541645,
      1,
      0.805488,
      0.160877,
      1.083122,
      1.105481,
      0,
      3,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      3,
      9.554518,
      2,
      3.087440,
      NULL,
      5.830737,
      1.170701,
      0,
      4,
      NULL,
      2.721024,
      NULL,
      1,
      NULL,
      NULL,
      8,
      0.770543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941855,
      1.371908,
      1,
      NULL,
      0,
      0.347256,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.780989,
      NULL,
      NULL,
      NULL,
      NULL,
      1.264269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.045174,
      0,
      1.162256,
      NULL,
      NULL,
      NULL,
      5.029465,
      1,
      0,
      1,
      0.675768,
      1,
      1.428098,
      NULL,
      NULL,
      NULL,
      0,
      1.161944,
      0.442702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328099,
      NULL,
      NULL,
      1.939134,
      3.442716,
      0.882459,
      1,
      1,
      NULL,
      1.081216,
      NULL,
      NULL,
      0.431085,
      1,
      1.143436,
      1.369162,
      1,
      NULL,
      1,
      0.859276,
      NULL,
      NULL,
      NULL,
      0,
      1.751293,
      1,
      1.565047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.485038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.264918,
      '22340',
      '02241',
      NULL,
      1.497118,
      '',
      '',
      NULL,
      0.388847,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


