set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-11-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      NULL,
      '4303332',
      130.890908,
      2,
      0.211503,
      2,
      '200240',
      1,
      ' 1-13-1998',
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.728615,
      0,
      NULL,
      0.429961,
      0.746251,
      2.644938,
      1.659624,
      1.665615,
      1.925363,
      3,
      NULL,
      1.550419,
      1,
      0,
      1.269632,
      5,
      1,
      NULL,
      0,
      0.902365,
      NULL,
      5,
      NULL,
      4.951001,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.743009,
      1.593692,
      1.104802,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822908,
      0.121191,
      1,
      1.251266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.764746,
      1,
      1,
      0,
      0.751324,
      NULL,
      0,
      1.113021,
      0,
      1.035544,
      0.661454,
      1.128902,
      1,
      1,
      1.590971,
      1.212459,
      1,
      NULL,
      NULL,
      3.881230,
      1.967269,
      1.873666,
      1,
      0,
      1,
      1.996343,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      NULL,
      0.721424,
      2,
      5,
      NULL,
      1,
      2,
      0,
      1,
      5.044701,
      0.569803,
      3.699219,
      2.607383,
      2,
      NULL,
      0,
      1,
      1.724279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.775171,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654315,
      NULL,
      2.988577,
      0,
      0.430566,
      1.374683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.469826,
      NULL,
      1.569654,
      NULL,
      NULL,
      NULL,
      3.873998,
      1.335186,
      2,
      6.055148,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0.015189,
      3.582230,
      1.679075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.760229,
      3.546226,
      NULL,
      NULL,
      3,
      0,
      0.798199,
      1,
      0,
      2.785439,
      3,
      NULL,
      1.207518,
      1,
      1,
      1,
      0.774569,
      NULL,
      1.299499,
      1.075035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.016117,
      NULL,
      '40130',
      '',
      NULL,
      '',
      NULL,
      '',
      0.782674,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


