set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      164,
      5,
      0.913099,
      1,
      '101403',
      NULL,
      ' 8- 4-1985',
      2.038464,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.273515,
      NULL,
      1.014142,
      0,
      1.419429,
      NULL,
      0,
      0,
      0.773077,
      1.391743,
      0,
      0,
      1,
      2,
      NULL,
      2.446252,
      NULL,
      1,
      NULL,
      4,
      0,
      1.432852,
      0.635525,
      0.419146,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.185827,
      0.937336,
      0.263955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.967437,
      0.893610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.917975,
      NULL,
      0.147974,
      1,
      0,
      1,
      1.492779,
      1.381817,
      0.782911,
      1.662866,
      1,
      0,
      NULL,
      1,
      1.750918,
      1.243167,
      NULL,
      1.394674,
      NULL,
      NULL,
      2.205040,
      1.979603,
      NULL,
      NULL,
      0.439837,
      2,
      0.863085,
      7,
      1.401162,
      0,
      5,
      0.626804,
      0,
      5,
      NULL,
      4.393063,
      8.126973,
      NULL,
      4.578364,
      1,
      0,
      1,
      3,
      7.517830,
      0,
      1,
      0,
      NULL,
      1,
      0.329832,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0.019209,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1.498262,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.601116,
      NULL,
      NULL,
      NULL,
      4,
      1.952171,
      4,
      NULL,
      1.088541,
      2,
      0.868582,
      NULL,
      NULL,
      NULL,
      0.765782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.375861,
      1,
      NULL,
      0.643505,
      0.853755,
      2.446570,
      NULL,
      2,
      0.082279,
      2.922547,
      0.140721,
      2.386052,
      0,
      1,
      1.201953,
      0,
      1,
      1.661567,
      1.308798,
      1,
      0.482439,
      1,
      0.722803,
      0,
      3.314038,
      3,
      3,
      0.234070,
      1,
      0,
      0,
      1,
      0,
      2.834448,
      2.357876,
      1.432756,
      1.642476,
      0.593935,
      0,
      NULL,
      1.199066,
      NULL,
      0.215463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      '30441',
      '',
      1.674058,
      '',
      '',
      '',
      0.449600,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


