set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '323',
      '13',
      24,
      8,
      NULL,
      57,
      5,
      0.955559,
      2,
      '043001',
      1,
      '10-27-1987',
      52,
      26,
      NULL,
      NULL,
      3.281019,
      3.460868,
      NULL,
      0.590121,
      1.871469,
      0.764194,
      NULL,
      0,
      NULL,
      0.607209,
      1.926572,
      NULL,
      NULL,
      1.042378,
      1,
      0.780156,
      NULL,
      1,
      4,
      1.406091,
      0,
      0.841629,
      4,
      1,
      4,
      0,
      1.235303,
      0.924123,
      NULL,
      NULL,
      1.574410,
      NULL,
      NULL,
      0,
      NULL,
      1.338979,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.909453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095111,
      NULL,
      1,
      1.475856,
      NULL,
      1.681375,
      0.465317,
      0,
      NULL,
      0,
      0,
      1,
      1.901760,
      1,
      1.081448,
      0,
      1,
      1.475770,
      1.003122,
      NULL,
      1,
      1.964105,
      0.160515,
      NULL,
      NULL,
      1.547556,
      4.350358,
      0,
      2.539839,
      4.923347,
      5,
      0,
      0.790240,
      1,
      2,
      1.201655,
      NULL,
      2,
      NULL,
      4,
      8,
      6.882172,
      1.036526,
      6.320087,
      0,
      1,
      0.832663,
      NULL,
      3,
      NULL,
      1,
      5.574655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358734,
      1,
      0,
      0,
      0.664013,
      0,
      0.217723,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.852225,
      NULL,
      0.057037,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.167555,
      2,
      1.614716,
      NULL,
      NULL,
      NULL,
      1.276002,
      0,
      9,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.589186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.729912,
      0.526551,
      NULL,
      0,
      1,
      1,
      1,
      3.371772,
      1.594349,
      2,
      2,
      1,
      0,
      3.686445,
      0.536732,
      1,
      NULL,
      0,
      0,
      1,
      1.259714,
      1,
      3,
      3,
      3.523079,
      NULL,
      1,
      0.693251,
      NULL,
      0.006914,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1.001920,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '41021',
      '40213',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


