set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '444',
      NULL,
      NULL,
      NULL,
      '2004044',
      51,
      NULL,
      3.413270,
      0,
      NULL,
      5,
      ' 6-20-1992',
      25.377457,
      28,
      1.902667,
      NULL,
      NULL,
      0.196852,
      0,
      1,
      0,
      NULL,
      1,
      0.367069,
      1,
      NULL,
      NULL,
      1,
      1.373499,
      1.757274,
      NULL,
      0,
      NULL,
      0.387299,
      4.304031,
      0.072416,
      1,
      1,
      7.404882,
      1,
      0,
      1.376316,
      1,
      1.812938,
      NULL,
      NULL,
      1.957230,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390878,
      NULL,
      1.815531,
      0.487988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1.134644,
      1.256391,
      1,
      1,
      1.786955,
      0.772906,
      0,
      1.788429,
      1,
      NULL,
      0.512494,
      0,
      0.336169,
      1.249778,
      0.591402,
      NULL,
      NULL,
      0.434406,
      2,
      NULL,
      0,
      1,
      0.649690,
      5,
      0.110410,
      NULL,
      NULL,
      0,
      1.415764,
      1.033784,
      0,
      6,
      0,
      NULL,
      11,
      0.937745,
      NULL,
      3,
      5,
      0,
      3.557572,
      NULL,
      0.461936,
      NULL,
      0,
      NULL,
      0.606085,
      0,
      3.703181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.459365,
      0.732094,
      0,
      1,
      0.700236,
      1,
      1.620325,
      1.778335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.933744,
      5.023913,
      0.054532,
      1,
      0,
      NULL,
      2.087298,
      5,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8,
      3.793670,
      3.875527,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.135562,
      0,
      3,
      2.591430,
      2,
      0.940079,
      NULL,
      3,
      NULL,
      3.030813,
      0,
      NULL,
      1.081096,
      1.268519,
      1.596252,
      1,
      3,
      NULL,
      0,
      NULL,
      0.639595,
      2.726811,
      0.040348,
      1.964634,
      1.444621,
      0,
      1,
      NULL,
      1.567762,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.310952,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '02322',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


