set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '402',
      '44',
      2.735053,
      25,
      '3412011',
      68.222549,
      2,
      NULL,
      3,
      '413030',
      5,
      ' 4-24-1985',
      35,
      59,
      0,
      NULL,
      1.736147,
      3.857952,
      1.243942,
      NULL,
      0.369196,
      1.515520,
      0,
      0,
      1.482922,
      1,
      3.734872,
      NULL,
      1.763445,
      0.393410,
      1.902669,
      NULL,
      5.943382,
      1.845104,
      0.216914,
      1.338460,
      0.060440,
      NULL,
      4.423205,
      0,
      1,
      0.571380,
      0,
      0.656039,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1.692664,
      0.958244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.007471,
      0.421116,
      0.998690,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.888044,
      0.151887,
      1,
      NULL,
      NULL,
      0,
      0.035503,
      0,
      0.040620,
      0.329164,
      1.929246,
      0,
      0,
      1,
      1.032238,
      0.151858,
      1,
      1.649801,
      NULL,
      NULL,
      NULL,
      5.785194,
      1.867600,
      1,
      1.743429,
      0.338154,
      1.221077,
      1.135180,
      1.514791,
      0.938649,
      3,
      7,
      1,
      1,
      3,
      1.551538,
      2.884103,
      5,
      3.047689,
      4,
      NULL,
      NULL,
      3.181366,
      6,
      0,
      5.759609,
      1.209055,
      4.270983,
      0,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.284942,
      1,
      0.636747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.654188,
      0,
      NULL,
      NULL,
      NULL,
      3.143818,
      0,
      5,
      2.081725,
      0.011289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.688312,
      NULL,
      3.288577,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.478307,
      2,
      0,
      1,
      NULL,
      0,
      0,
      0.676808,
      1,
      1,
      0.195340,
      0,
      0.783307,
      0,
      NULL,
      2.280042,
      NULL,
      0.588463,
      1,
      0.115719,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      1.895331,
      0.546436,
      0.381355,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '33341',
      '40002',
      '',
      1.461626,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


