set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      '11',
      5,
      NULL,
      NULL,
      117.816248,
      0,
      1,
      2,
      '400410',
      2,
      ' 9- 0-1990',
      6.806289,
      25.156012,
      0.686978,
      NULL,
      2,
      1.272360,
      NULL,
      0.596534,
      1,
      NULL,
      1.257250,
      1.679075,
      0,
      0.472101,
      2,
      0.596034,
      0,
      1.492205,
      NULL,
      0.085619,
      7.293828,
      0,
      1,
      0,
      0.043783,
      NULL,
      4,
      1,
      1.013766,
      1.361719,
      1.630266,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.972841,
      1,
      0,
      0.143906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1.395473,
      NULL,
      1.464487,
      NULL,
      1.441455,
      0,
      0,
      NULL,
      1.282477,
      NULL,
      0.105722,
      3,
      1.277238,
      1,
      1.991714,
      0,
      NULL,
      0.991767,
      2.812405,
      0.745484,
      4.747960,
      2,
      NULL,
      1,
      NULL,
      1.186679,
      6.068891,
      2.387707,
      NULL,
      0,
      0,
      4.691663,
      2.441984,
      5,
      5.406154,
      0.517378,
      NULL,
      1.154243,
      1.468442,
      NULL,
      NULL,
      8.767387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713546,
      0,
      1,
      0,
      1.542494,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      2,
      3.723310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.692505,
      1,
      4.456480,
      NULL,
      0,
      1,
      1.175124,
      NULL,
      NULL,
      NULL,
      0,
      7.677604,
      1.514569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.182615,
      NULL,
      NULL,
      0.698385,
      1.019677,
      0.546898,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.299741,
      2,
      NULL,
      0,
      1.902448,
      0.461713,
      NULL,
      0.552054,
      2,
      1,
      1,
      0.058341,
      NULL,
      1,
      1.096387,
      NULL,
      0.312786,
      0,
      0,
      0,
      0.115931,
      NULL,
      1.599018,
      1,
      1,
      0,
      1.521985,
      1.661487,
      0.932733,
      0,
      0,
      0.699854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.293416,
      '31042',
      '40433',
      '',
      NULL,
      '',
      '',
      '',
      1.095026,
      '2121',
      NULL,
      '',
      NULL,
      1,
      3.286596,
      1,
      0,
      3.672537,
      NULL,
      NULL,
      1);
commit;
end;
/


