set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '312',
      '10302432',
      NULL,
      45.261024,
      '4404302',
      NULL,
      1,
      1.861239,
      NULL,
      '123333',
      2,
      ' 6-23-1989',
      6.363178,
      7.674487,
      0,
      NULL,
      1.737851,
      0.513564,
      1.636654,
      0,
      0.050484,
      NULL,
      1.290255,
      1,
      1.608320,
      1,
      1.226505,
      0,
      NULL,
      0,
      1.948845,
      0.035948,
      NULL,
      1,
      0.817321,
      0.316310,
      0,
      1,
      4.122608,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.035235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.064141,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.648792,
      5,
      1,
      NULL,
      0.585755,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.624944,
      0,
      NULL,
      0.096888,
      NULL,
      1.552655,
      NULL,
      0.197695,
      0.622231,
      1.083020,
      1,
      5,
      1.212618,
      3.622915,
      0,
      NULL,
      3.112129,
      0.904972,
      NULL,
      2,
      2.925675,
      6.758283,
      9,
      NULL,
      7.332943,
      0,
      6.311838,
      0,
      0,
      2,
      2,
      1,
      NULL,
      0.648044,
      NULL,
      NULL,
      5.630502,
      0.268981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.801889,
      0,
      0,
      0,
      0,
      1.449459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.688792,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118457,
      NULL,
      1.912312,
      NULL,
      1.553714,
      2,
      1.664893,
      NULL,
      NULL,
      NULL,
      NULL,
      3.401300,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      3,
      2,
      1.873820,
      1,
      0,
      3.795383,
      3.085842,
      1.491759,
      2,
      NULL,
      1.345328,
      0.635132,
      NULL,
      1,
      NULL,
      0,
      1,
      1.806471,
      0.839706,
      2.499072,
      2.447081,
      1,
      NULL,
      0.218435,
      1.707754,
      0,
      0,
      NULL,
      1.221729,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.375218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      '33114',
      NULL,
      NULL,
      '',
      '',
      '',
      1.059769,
      '4442',
      NULL,
      '',
      NULL,
      3.215019,
      NULL,
      1,
      3.096974,
      0.437921,
      3.199155,
      1,
      3.379156);
commit;
end;
/


