set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      22.225220,
      24,
      '4132101',
      24.733289,
      NULL,
      1,
      1,
      '132434',
      3,
      '10-17-1979',
      25.650362,
      44,
      1.700622,
      NULL,
      2.287626,
      1,
      0,
      0,
      0.720580,
      0.009471,
      2.903771,
      0.087104,
      0.213308,
      1.808845,
      0.734909,
      1,
      0.833621,
      1,
      0.404779,
      1,
      NULL,
      0.672393,
      0,
      0.498906,
      NULL,
      0.730467,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1.476806,
      NULL,
      NULL,
      1,
      0.090138,
      0.863687,
      1.706489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.927557,
      0.434408,
      0,
      0.732079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613253,
      0.560782,
      5.552755,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.723190,
      0,
      0,
      1.077436,
      0.347632,
      0,
      NULL,
      0.337773,
      0,
      1.820282,
      NULL,
      1.706159,
      NULL,
      0.380624,
      1,
      0.007530,
      0,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      3.274416,
      NULL,
      NULL,
      7.551631,
      NULL,
      9.036476,
      NULL,
      5.216737,
      3,
      3.607789,
      0.265900,
      5,
      4.784142,
      0,
      0,
      1.467814,
      0.488519,
      3.550470,
      0.281470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.569368,
      0,
      1,
      0.693686,
      1,
      0.658145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101368,
      NULL,
      9.695084,
      2.736280,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.110483,
      3,
      0.583441,
      2,
      1.385013,
      NULL,
      NULL,
      NULL,
      0,
      3.495136,
      1.286190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323073,
      1.350444,
      2,
      1,
      1,
      2,
      0.402916,
      1.565092,
      0,
      0,
      3.541645,
      1,
      3,
      3,
      NULL,
      NULL,
      1.849889,
      0,
      1.596406,
      0,
      NULL,
      1,
      1,
      1.413259,
      NULL,
      1,
      3.774870,
      NULL,
      0,
      NULL,
      1,
      0.525813,
      0,
      1,
      1,
      0,
      0.837576,
      0,
      1.820580,
      NULL,
      0.278976,
      1,
      0.862925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      '33114',
      '30342',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '1022',
      NULL,
      '',
      0,
      2,
      NULL,
      6,
      2.858046,
      NULL,
      2,
      2.902903,
      1.050373);
commit;
end;
/


