set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '002',
      '22042344',
      7.232609,
      35,
      '3341221',
      181,
      NULL,
      NULL,
      1,
      NULL,
      6,
      ' 1- 3-1991',
      50,
      49.148047,
      1.719295,
      NULL,
      NULL,
      0,
      0.571872,
      1,
      0.116607,
      1,
      0,
      0,
      0.671015,
      0,
      4.790461,
      0,
      NULL,
      1,
      0.423070,
      0,
      7.266183,
      NULL,
      NULL,
      0.903763,
      1.285459,
      1,
      2.078420,
      0,
      5,
      0.189843,
      1.881726,
      NULL,
      NULL,
      NULL,
      0.530344,
      NULL,
      NULL,
      0.626170,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.643517,
      1,
      0.628051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165926,
      1.632556,
      NULL,
      NULL,
      3.367100,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1.273836,
      0.697490,
      1,
      0.616217,
      NULL,
      0,
      0.962562,
      1,
      1,
      0.668066,
      NULL,
      5,
      1.696461,
      0.403538,
      1.558949,
      NULL,
      0,
      1.985810,
      1,
      2,
      1.261938,
      3.764657,
      NULL,
      4,
      7,
      4,
      2,
      3.897510,
      5,
      NULL,
      2,
      5.445587,
      4,
      1,
      NULL,
      NULL,
      1.349252,
      0.375011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215826,
      0,
      2,
      1,
      0.402798,
      NULL,
      1,
      1.134167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.414904,
      NULL,
      2.190698,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.805328,
      3.993220,
      0.439929,
      NULL,
      NULL,
      NULL,
      3.661838,
      1.980163,
      NULL,
      3.874212,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3.675335,
      1.084839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735913,
      NULL,
      NULL,
      0,
      3,
      3.199660,
      2.797120,
      3.756871,
      1.539261,
      0,
      1,
      3,
      NULL,
      0.122644,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0.977241,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      0,
      1,
      1.331801,
      1,
      0.591370,
      NULL,
      1,
      0.098992,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '22022',
      '10340010',
      '',
      0.135778,
      '',
      '',
      '',
      1.026903,
      '0410',
      '',
      '',
      NULL,
      NULL,
      3.277962,
      0.625241,
      1.326680,
      5,
      3,
      3,
      1.515877);
commit;
end;
/


