set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      72,
      29,
      '1231011',
      22,
      1,
      3.178612,
      NULL,
      '043213',
      NULL,
      ' 3- 7-1978',
      28.552028,
      NULL,
      NULL,
      NULL,
      2.811418,
      3.289209,
      1,
      1.853367,
      NULL,
      NULL,
      NULL,
      1.977653,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      6.931119,
      NULL,
      5.565180,
      1,
      NULL,
      1,
      5,
      1,
      NULL,
      0,
      3.704885,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.416457,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.401956,
      0.295285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.443952,
      0.395680,
      0.391819,
      0.717712,
      4,
      0.192785,
      0,
      0.949717,
      0,
      0,
      1,
      1.829803,
      0.107056,
      1.116464,
      0,
      1.781882,
      1.203244,
      0.425599,
      0,
      NULL,
      0,
      1.236923,
      0.179062,
      0,
      0,
      NULL,
      0.857853,
      NULL,
      5,
      1,
      NULL,
      3.485531,
      1.247731,
      1.397546,
      NULL,
      1,
      1.700535,
      5,
      NULL,
      3.630980,
      4.652318,
      8,
      NULL,
      0.738297,
      2.116898,
      NULL,
      1.741969,
      5.619029,
      0,
      NULL,
      NULL,
      7.265339,
      1.573664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.197171,
      NULL,
      2,
      1,
      1.033674,
      1.842319,
      3.004220,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.820220,
      1,
      1,
      1.004002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.854593,
      NULL,
      0.137955,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.645587,
      3,
      NULL,
      1.283687,
      1.114149,
      NULL,
      3,
      1,
      2.376988,
      1,
      1.820568,
      1,
      1.927208,
      0.774637,
      NULL,
      0.152669,
      3.317216,
      NULL,
      0,
      1.877241,
      0.700614,
      1,
      NULL,
      1.926587,
      2.504764,
      NULL,
      1,
      1.334995,
      NULL,
      0,
      0.736115,
      NULL,
      1,
      2,
      0,
      0.795297,
      1.833201,
      1,
      0.879039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.465315,
      '11002',
      '20431011',
      '',
      1.617029,
      '',
      NULL,
      NULL,
      0.345895,
      '',
      '',
      NULL,
      NULL,
      NULL,
      2,
      2.410118,
      NULL,
      5,
      2,
      2,
      3.643355);
commit;
end;
/


