set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '404',
      '32300143',
      63.143341,
      51,
      '0112423',
      NULL,
      3,
      2,
      1,
      '022320',
      5.472618,
      ' 2-10-1992',
      56,
      26,
      1.066733,
      NULL,
      0.596788,
      3,
      NULL,
      NULL,
      0.187752,
      NULL,
      2,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      1.068814,
      0.498216,
      NULL,
      2,
      1,
      1,
      1.975149,
      1,
      1.020354,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.689220,
      1,
      NULL,
      1.972850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.335601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616838,
      0.413218,
      1.262474,
      1,
      1,
      1,
      NULL,
      0.167855,
      NULL,
      1.778344,
      0,
      1.841050,
      0.886276,
      1.310124,
      NULL,
      1,
      NULL,
      1.262346,
      NULL,
      NULL,
      1.356771,
      0,
      1.994514,
      0.480270,
      0.384137,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      3.642586,
      NULL,
      3.400569,
      NULL,
      NULL,
      3,
      NULL,
      3.134840,
      NULL,
      NULL,
      3,
      4.438958,
      5.344776,
      NULL,
      2,
      1,
      0,
      8.919275,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1.735434,
      1.189380,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.032868,
      NULL,
      0.024327,
      0.410242,
      1,
      0,
      1,
      1.328489,
      NULL,
      1.766347,
      0.777119,
      4.896527,
      2.955852,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      6.817055,
      3,
      2.384159,
      NULL,
      1.172376,
      NULL,
      NULL,
      NULL,
      0,
      1.060702,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.289692,
      3.659176,
      0.368210,
      0.743724,
      1.107718,
      NULL,
      2.653065,
      0,
      1,
      0.102886,
      0,
      NULL,
      0.239512,
      0.975768,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.351826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.760899,
      '21330',
      '31312',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      4,
      0.984312,
      3,
      3.276923,
      3.149270,
      3.014306,
      0,
      2.374695,
      0.012922);
commit;
end;
/


