set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '344',
      NULL,
      42.737152,
      NULL,
      '3434014',
      NULL,
      6,
      NULL,
      0,
      '124023',
      2.540650,
      ' 2-13-1989',
      9,
      31.115118,
      0.568510,
      NULL,
      0.565365,
      1,
      1.866888,
      1,
      1.249554,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1.534587,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1.836016,
      0.552794,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.743210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.353808,
      1,
      1.918508,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      2.878415,
      NULL,
      0.188692,
      0,
      1.830758,
      1.955189,
      NULL,
      1.647556,
      1.837734,
      0.557241,
      1,
      1,
      NULL,
      NULL,
      0.672114,
      NULL,
      1.098290,
      NULL,
      0.669223,
      1.128892,
      0.027835,
      0,
      1,
      NULL,
      0,
      0,
      0.313057,
      3.878292,
      0,
      1,
      4.068168,
      0.994214,
      NULL,
      2.593420,
      4.918342,
      NULL,
      5,
      7,
      2,
      5.315627,
      2,
      5.897104,
      3.952401,
      4.393202,
      1.547213,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.261835,
      NULL,
      1,
      0.045581,
      1.890828,
      2.936202,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.558761,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1.375405,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.136304,
      NULL,
      4,
      4.073079,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.301850,
      3.889016,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.385901,
      0.580044,
      0,
      1,
      NULL,
      0,
      1.849166,
      1.463517,
      3,
      2,
      3.846082,
      3.267179,
      NULL,
      2.657095,
      1,
      0.690392,
      1.079976,
      NULL,
      0.616645,
      NULL,
      0.428166,
      NULL,
      0,
      1.029496,
      1.432994,
      3,
      3.789524,
      1.842549,
      0,
      1.101740,
      NULL,
      NULL,
      0.429552,
      NULL,
      0.519371,
      0,
      1.660559,
      1.005014,
      0.037659,
      NULL,
      NULL,
      0.761693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.089074,
      '23004',
      '44000',
      NULL,
      0,
      '',
      '',
      '',
      1.717663,
      '',
      NULL,
      NULL,
      0.916894,
      0.346701,
      3,
      2.133038,
      1.200211,
      0,
      0.612474,
      5,
      2.279656);
commit;
end;
/


