set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4203',
      '31403322',
      64.675555,
      66,
      '3204033',
      NULL,
      5,
      3.274598,
      2,
      '013313',
      NULL,
      ' 9-12-1983',
      NULL,
      56.559177,
      1,
      NULL,
      3,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0.636671,
      1,
      4.510094,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      1.892309,
      0.692743,
      NULL,
      1.565612,
      0.674689,
      NULL,
      NULL,
      1.182392,
      NULL,
      0.126656,
      1,
      NULL,
      NULL,
      1.505661,
      NULL,
      NULL,
      1.519313,
      NULL,
      NULL,
      0.647018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.344085,
      0.812707,
      NULL,
      0.780650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890850,
      0.958083,
      NULL,
      1.925737,
      1.797267,
      1,
      0.194600,
      0.424072,
      1,
      1.524793,
      3,
      0,
      1,
      1.551470,
      1,
      1.511172,
      1,
      1,
      0,
      NULL,
      0.063180,
      0,
      1.961575,
      0,
      1.186598,
      0.813120,
      1.188137,
      NULL,
      NULL,
      NULL,
      1.211834,
      2.594968,
      0.946954,
      1,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      6.872613,
      NULL,
      0.545217,
      0,
      NULL,
      5.037757,
      0.116464,
      4,
      0,
      NULL,
      NULL,
      1,
      1.509029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      2,
      1,
      6,
      NULL,
      3.145363,
      0,
      1.511565,
      4.563677,
      2.520943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.215008,
      1,
      0.755825,
      1.418574,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.341296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893219,
      0,
      0.045220,
      0.496820,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.465460,
      0,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.806026,
      1.588261,
      0,
      0,
      1,
      0,
      1.640794,
      2,
      1.569023,
      NULL,
      2.206285,
      1.188638,
      2.087696,
      NULL,
      3.430081,
      0.407924,
      2,
      2.766702,
      NULL,
      3,
      NULL,
      0.700137,
      1.879312,
      0.441859,
      1,
      3.531701,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.567272,
      NULL,
      1,
      NULL,
      0.242138,
      0.599277,
      1.656821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068113,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      '11303',
      '14330',
      '',
      1.813146,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      4.971828,
      3.024188,
      0,
      4.747575,
      3.333146,
      3,
      1.014479,
      4.055192,
      0);
commit;
end;
/


