set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4004',
      '21444241',
      50,
      NULL,
      '1332441',
      234,
      3,
      NULL,
      0,
      '410224',
      NULL,
      ' 1-17-1999',
      40,
      42.537807,
      1,
      NULL,
      1.794446,
      NULL,
      0.144141,
      1.409686,
      1.355039,
      NULL,
      0.517926,
      NULL,
      NULL,
      1,
      5.116831,
      1.063935,
      1,
      NULL,
      1,
      0.145393,
      NULL,
      0,
      1.705762,
      0,
      NULL,
      1.664563,
      3,
      1,
      NULL,
      0.065103,
      NULL,
      0.880375,
      NULL,
      NULL,
      1.482585,
      NULL,
      NULL,
      NULL,
      1.576864,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527104,
      0.651451,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.939123,
      5,
      NULL,
      NULL,
      NULL,
      0.510450,
      1.607160,
      0,
      0.546013,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1.203623,
      1,
      0.610729,
      NULL,
      0.355213,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.941640,
      0.095389,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1,
      3,
      5.231925,
      2.484695,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.783074,
      1.072408,
      3,
      4,
      1,
      NULL,
      NULL,
      6.203826,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445974,
      0.021806,
      2,
      NULL,
      1,
      1.859570,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.903326,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.507026,
      4,
      2.268078,
      3.493593,
      NULL,
      0.957259,
      NULL,
      NULL,
      NULL,
      2.184345,
      1.059086,
      0.893864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830265,
      1,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.538824,
      0,
      1,
      1.336121,
      2,
      1,
      0.461087,
      0,
      1,
      3.539985,
      0,
      1,
      1,
      1.959018,
      3.162802,
      1,
      1.879859,
      2,
      0.741088,
      NULL,
      0.891193,
      NULL,
      1.957805,
      3.917398,
      2,
      NULL,
      0.960876,
      1.408336,
      NULL,
      NULL,
      0.642289,
      1,
      1.420038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '31404',
      '24420',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.932766,
      5,
      0.013341,
      4,
      0.742615,
      NULL,
      0,
      NULL,
      1.549549);
commit;
end;
/


