set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4110',
      NULL,
      65.390852,
      70.599020,
      '2443222',
      342,
      2,
      1.446493,
      1,
      '142313',
      NULL,
      ' 8-22-1982',
      NULL,
      4,
      1,
      NULL,
      NULL,
      0.080406,
      3.917732,
      NULL,
      1.809326,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1.435538,
      1,
      0.184247,
      1.343788,
      NULL,
      1.425545,
      0,
      0.293794,
      1,
      0.722640,
      5.370940,
      0,
      NULL,
      NULL,
      1,
      0.366201,
      NULL,
      NULL,
      0.414392,
      NULL,
      NULL,
      1.097295,
      0.961527,
      0.788527,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.207593,
      NULL,
      NULL,
      1.115711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640090,
      1.155898,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.520460,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.528757,
      NULL,
      0,
      NULL,
      1,
      0.295272,
      1.427343,
      0.361359,
      4.212408,
      4,
      NULL,
      1.749938,
      2.837538,
      NULL,
      NULL,
      1,
      3.829908,
      7,
      0,
      5,
      4,
      2,
      5,
      1.359629,
      NULL,
      1.418480,
      NULL,
      2.160370,
      1.105862,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.359345,
      NULL,
      1,
      1,
      1.555066,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955292,
      NULL,
      5.274874,
      NULL,
      1.647524,
      NULL,
      3,
      NULL,
      NULL,
      1,
      4.864533,
      4.632604,
      2.283856,
      0.186809,
      NULL,
      NULL,
      NULL,
      NULL,
      0.603388,
      NULL,
      0,
      1,
      2,
      1.625481,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.007536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.761868,
      0.088331,
      NULL,
      NULL,
      1.059631,
      0,
      1.424666,
      NULL,
      NULL,
      1.718531,
      1.407264,
      0.460471,
      3.208833,
      0,
      1,
      NULL,
      1,
      3.618013,
      1,
      1,
      1.789612,
      NULL,
      2,
      3,
      2,
      2.089017,
      1.789102,
      0.018660,
      NULL,
      2,
      0.115399,
      NULL,
      3,
      0.130678,
      NULL,
      1.120307,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      NULL,
      NULL,
      '',
      0.768717,
      NULL,
      '',
      '',
      0.163373,
      '',
      '',
      '',
      0.895869,
      NULL,
      3.525323,
      0,
      0,
      2.898886,
      2,
      4,
      0.920016);
commit;
end;
/


