set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9518951';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-1-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      '410133',
      2,
      NULL,
      17,
      NULL,
      0.036261,
      NULL,
      NULL,
      3,
      0,
      0,
      2,
      1,
      NULL,
      0.614493,
      NULL,
      1,
      2.191665,
      1,
      NULL,
      0,
      1.686559,
      NULL,
      4.103795,
      0,
      0.716903,
      0.667064,
      0,
      1,
      1.661937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968768,
      1.276567,
      1.847602,
      2.259576,
      1.381760,
      NULL,
      3,
      0,
      NULL,
      1.760055,
      NULL,
      3,
      NULL,
      2,
      3.453855,
      3.124424,
      0,
      0.489081,
      0,
      2,
      1.033850,
      0.238196,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.411876,
      1.492363,
      1.862199,
      1,
      0.779205,
      0.657312,
      NULL,
      0.728600,
      1,
      1,
      1,
      1.576317,
      NULL,
      5.013762,
      0,
      0,
      0.595976,
      NULL,
      NULL,
      NULL,
      0.277519,
      2.696905,
      NULL,
      NULL,
      2,
      1.618387,
      5.040086,
      1.301902,
      1,
      1,
      6,
      0,
      3,
      NULL,
      7,
      NULL,
      0,
      1,
      NULL,
      3,
      6,
      5.930753,
      1.820278,
      NULL,
      6,
      3.008443,
      NULL,
      2,
      3.691994,
      NULL,
      NULL,
      0.955372,
      1.047778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.188323,
      NULL,
      0,
      1.789700,
      0.445209,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.697332,
      NULL,
      3,
      NULL,
      3.232170,
      7.698451,
      3,
      0.288238,
      0,
      0.676503,
      4.904878,
      NULL,
      3,
      0.271725,
      NULL,
      NULL,
      NULL,
      NULL,
      0.270509,
      6,
      NULL,
      NULL,
      0,
      3.818359,
      1.887051,
      NULL,
      NULL,
      0.445641,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.201697,
      NULL,
      0,
      NULL,
      1,
      1.863909,
      0,
      0.597774,
      1.229912,
      2,
      0,
      0.913843,
      NULL,
      1.730636,
      1.730700,
      1,
      0.872825,
      1.412387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.701341,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.211317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1.177573,
      '43100',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.920303,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


