set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9518951';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '411',
      '22',
      25,
      3,
      NULL,
      7.199215,
      0,
      3.855084,
      1,
      '204244',
      0.782112,
      ' 5-22-1983',
      54.093429,
      30.352052,
      NULL,
      NULL,
      3.022958,
      1,
      0.620884,
      1,
      1,
      1,
      0.202515,
      NULL,
      2,
      NULL,
      1.226595,
      1.954218,
      0,
      1.044945,
      NULL,
      NULL,
      0.054088,
      0,
      4.241862,
      1,
      1,
      NULL,
      2.964591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.265243,
      0.760140,
      3.481107,
      0,
      1,
      2.222386,
      1.289347,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.650467,
      1,
      0,
      1,
      1.686505,
      1,
      5.367707,
      0,
      1,
      1.712124,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.672748,
      1,
      0.815378,
      NULL,
      1.505643,
      NULL,
      1,
      1,
      0.173039,
      NULL,
      1,
      0.993733,
      0.672474,
      1.766870,
      0.533149,
      1,
      1.690230,
      NULL,
      NULL,
      0,
      1,
      0,
      0.921923,
      0,
      1.356876,
      1.260746,
      1.827172,
      1,
      0.216462,
      NULL,
      NULL,
      0,
      0.540572,
      5,
      1,
      1,
      4,
      0.488267,
      0.399219,
      3.814521,
      1.665529,
      2.098910,
      5.669705,
      0,
      2,
      4.203830,
      NULL,
      NULL,
      NULL,
      NULL,
      7.269288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6,
      0.582970,
      0,
      6,
      3.095364,
      2,
      0.238838,
      NULL,
      4,
      NULL,
      2.662435,
      0.867420,
      NULL,
      NULL,
      NULL,
      0.144110,
      1.680658,
      0,
      4,
      6.316129,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.316354,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.900674,
      NULL,
      1.211049,
      1.188739,
      1.064193,
      3.598518,
      0.923450,
      0,
      1.582883,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '42312',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      0.845639,
      NULL,
      '',
      NULL,
      2.523334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


