set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9518951';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      '03',
      3.045891,
      NULL,
      '2332440',
      26.242653,
      6,
      3.221201,
      NULL,
      '242313',
      NULL,
      ' 2-28-2002',
      NULL,
      63,
      NULL,
      NULL,
      0.420237,
      2.621089,
      NULL,
      0.590858,
      0,
      0.832577,
      1,
      0.321671,
      2.149214,
      0.990511,
      1.582384,
      1.821603,
      NULL,
      1,
      1,
      NULL,
      4,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1.487898,
      5.242341,
      5.522658,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1.057317,
      0.346457,
      0.785130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.906672,
      1,
      0,
      NULL,
      0,
      1,
      2,
      0.210171,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.801805,
      0.311113,
      0.361305,
      1.373220,
      4.055027,
      0.053901,
      0.382855,
      2.292083,
      1,
      NULL,
      0.692216,
      1,
      0,
      5.813254,
      3,
      0.742569,
      2.047690,
      1,
      2.684750,
      0,
      4,
      9,
      5,
      7,
      0,
      0,
      0.747545,
      0,
      NULL,
      7.667283,
      4,
      9.566789,
      0.468443,
      2.964868,
      0.974994,
      9,
      0,
      8,
      4.208143,
      6,
      NULL,
      6.808283,
      0,
      NULL,
      NULL,
      6,
      NULL,
      7,
      2,
      1,
      1.064170,
      0,
      1.893409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881651,
      1.246096,
      0,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.224937,
      NULL,
      3,
      3,
      2,
      1.585500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.500687,
      2,
      1,
      1.260268,
      5.798085,
      9.890866,
      6,
      4,
      2,
      1,
      2.168044,
      2.240053,
      1,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.727865,
      NULL,
      2,
      1.088815,
      1.531498,
      1,
      NULL,
      0.402289,
      3,
      0.588788,
      1.769611,
      0.126828,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.269172,
      NULL,
      '',
      '',
      1.981790,
      '',
      NULL,
      '',
      1.520730,
      '',
      '',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


